function cdx_new = update_model_y0_v2(CDX, discounts_IMM, N, start_date_num, end_date_num, maturities_cds, maturities_tranches, ...
                                      RMSE_method, LGD_method, algo, method5, method2, CDX2)
% --------------------------------------------------------------------------------------------------
% Update the model implied initial default intensity of the common factor (between start_date and
% end_date).
% --------------------------------------------------------------------------------------------------
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% discounts_IMM                 ... structure with discount curves matching IMM dates
% N                             ... number of points for numerical integration of Fourier transform
% alpha                         ... interval shrinkage factor for search of Y0, default: 0.7
% start_date_num                ... datenum of start date
% end_date_num                  ... datenum of end date
% maturities_cds                ... which maturities to fit for CDS prices
% maturities_tranches           ... which maturities to fit for tranche prices
% RMSE_method                   ... which definition of pricing error to use
% LGD_method                    ... method for (joint) distribution of LGDs
% algo                          ... search algorithm:
%                                   1 ... interval search based on derivatives
%                                   2 ... classical interval search with shrinkage factor of 0.75
% method5                       ... which definition to use for the 5th parameters
%                                   'mu' = expected jump size \mu (default)
%                                   'mu*L' = jump intensity x jump size
% method2                       ... which definition to use for the 2nd parameter
%                               ... 'thet' = theta_total
%                               ... 'thet*k' = theta_total * k
% CDX2                          ... second CDX structure for robust RMSE calculation (optional)
% --------------------------------------------------------------------------------------------------
% sample call: update_model_y0_v2(CDX_NA_IG_monthly, discounts_IMM, 1000, datenum('02/01/2006'), datenum('03/01/2006'), [1 0 0], 1, 0, 2)
% --------------------------------------------------------------------------------------------------

% Set default values
alpha = 0.75;
if (nargin <= 12)
    CDX2 = [];
end

% Determine relevant date range
start_pos = find(CDX.dates{1} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{1} <= end_date_num, 1, 'last');
used_range = start_pos:end_pos;
used_dates = CDX.dates{1}(used_range);
num_dates = length(used_dates);

% % Determine constraints: Y_t <= min(lambda_it/ai)
% [a, trash, trash2, lambda] = get_portfolio_parameters(CDX, start_date_num, end_date_num);
% Y_t_upper = zeros(1, num_dates);
% for i=1:num_dates
%     pos = used_range(i);
%     used = logical(CDX.index_members(pos,:));
%     lambda_t = lambda(i,used);
%     ai = a(i,used);
%     neg_pos = (lambda_t == -1);      % remove missing intensities which are coded as -1
%     Y_t_upper(i) = min(lambda_t(~neg_pos) ./ ai(~neg_pos)); 
% end
% % Y_t_upper = min( lambda(:,used)' ./ repmat(a(used), size(lambda,1), 1)' );
% % Y_t_upper = min(Y_t_upper, 0.005);
% disp(['Y_t_upper: ' num2str(Y_t_upper)])
% upper = min(Y_t_upper', 0.01);

% Use vectorized interval search for initial default intensity
% if (num_dates ~= length(Y_t_upper))
%     error('Length of Y_t_upper and used_range disagree.');
% end
if (~isfield(CDX, 'y0'))
    CDX.y0 = repmat(1e-4, num_dates, 1);
end
lower = repmat(1e-4, num_dates, 1);
upper = repmat(1e-2, num_dates, 1);
[rms, trash, rms_5yr_cds] = mispricing_CDX_y0(lower, CDX, discounts_IMM, N, start_date_num, end_date_num, ...
                                              maturities_cds, maturities_tranches, RMSE_method, LGD_method, method5, method2, CDX2);
lower_mispricing = rms + 5*rms_5yr_cds;                           
[rms, trash,rms_5yr_cds] = mispricing_CDX_y0(upper, CDX, discounts_IMM, N, start_date_num, end_date_num, ...
                                             maturities_cds, maturities_tranches, RMSE_method, LGD_method, method5, method2, CDX2);
upper_mispricing = rms + 5*rms_5yr_cds;                                                                        

% grid = (0.1:0.1:1);
% values = zeros(num_dates, length(grid));
% for i=1:length(grid)
%     [values(:,i), tmp] = mispricing_CDX_y0(grid(i) * Y_t_upper', CDX, discounts_IMM, N, start_date_num, end_date_num, ...
%                                          maturities_cds, maturities_tranches, RMSE_method, LGD_method);
%     if (i==1)
%         cdx_series = tmp;
%     else
%         cdx_series(i) = tmp;
%     end
% end
% plot(grid, values);
    
% Algorithm I: use (vectorized) interval search for value of xi based on derivative
if (algo == 1)
    while(max(upper - lower) > 1e-6)
        % Compute derivative of mispricing error in middle of search interval
        middle = (upper+lower)/2;
        disp(['middle_y0: ' num2str(middle')]);
        [rms_tranches, trash, rms_5yr_cds] = mispricing_CDX_y0(middle-5e-6, CDX, discounts_IMM, N, start_date_num, end_date_num, ...
                                                               maturities_cds, maturities_tranches, RMSE_method, LGD_method, method5, method2, CDX2);
        [rms_tranches2, trash, rms_5yr_cds2] = mispricing_CDX_y0(middle+5e-6, CDX, discounts_IMM, N, start_date_num, end_date_num, ...
                                                                 maturities_cds, maturities_tranches, RMSE_method, LGD_method, method5, method2, CDX2);
        middle_mispricing = rms_tranches + 5*rms_5yr_cds;
        middle_mispricing2 = rms_tranches2 + 5*rms_5yr_cds2;
        derivative = (middle_mispricing2 - middle_mispricing) / 1e-5;
        disp(['derivative: ' num2str(derivative')]);

        % Check that algorithm isn't doing something stupid
        stupid = (min(middle_mispricing, middle_mispricing2) > lower_mispricing + 1e-4) & ...
                 (min(middle_mispricing, middle_mispricing2) > upper_mispricing + 1e-4);
        if (sum(stupid * 1) > 0)
            % error('Algorithm is doing something stupid!');
            disp('Algorithm is doing something stupid! Increasing number of grid points by 2000.');
            N = N + 2000;
            lower_mispricing = mispricing_CDX_y0(lower, CDX, discounts_IMM, N, start_date_num, end_date_num, ...
                                                 maturities_cds, maturities_tranches, RMSE_method, LGD_method, method5, method2, CDX2);
            upper_mispricing = mispricing_CDX_y0(upper, CDX, discounts_IMM, N, start_date_num, end_date_num, ...
                                                 maturities_cds, maturities_tranches, RMSE_method, LGD_method, method5, method2, CDX2);
            continue;
        end

        % Narrow down search interval
        slope_positive = (derivative > 0);
        upper(slope_positive) = middle(slope_positive);
        upper_mispricing(slope_positive) = middle_mispricing(slope_positive);
        lower(~slope_positive) = middle(~slope_positive);    
        lower_mispricing(~slope_positive) = middle_mispricing(~slope_positive);
    end
end

% Algorithm II: use classical (vectorized) interval search (more stable)
if (algo == 2)
    while (max(upper - lower) > 1e-6)
        % Compute mispricing error in weighted middle of search interval
        middle = zeros(num_dates, 1);
        lower_better = lower_mispricing <= upper_mispricing;
        middle(lower_better) = (1-alpha)*lower(lower_better) + alpha*upper(lower_better);
        middle(~lower_better) = alpha*lower(~lower_better) + (1-alpha)*upper(~lower_better);
        disp(['middle_y0: ' num2str(middle')]);
        [rms_tranches, trash, rms_5yr_cds] = mispricing_CDX_y0(middle, CDX, discounts_IMM, N, start_date_num, end_date_num, ...
                                              maturities_cds, maturities_tranches, RMSE_method, LGD_method, method5, method2, CDX2);
        middle_mispricing = rms_tranches + 5*rms_5yr_cds;

        % Narrow down search interval
        upper(lower_better) = middle(lower_better);
        upper_mispricing(lower_better) = middle_mispricing(lower_better);
        lower(~lower_better) = middle(~lower_better);    
        lower_mispricing(~lower_better) = middle_mispricing(~lower_better);    
    end
end

% Update model-implied tranche prices and calculate relative RMSE
y0 = (lower+upper)/2;
CDX.y0(used_range) = y0;
[trash, cdx_new] = wrapper_tranche_mispricing(get_x0(CDX, used_dates, method5, method2), CDX, discounts_IMM, start_date_num, end_date_num, N, ...
                                     maturities_cds, maturities_tranches, RMSE_method, LGD_method, 2, method5, method2, CDX2);
